VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "AO Recycle Mode"
   ClientHeight    =   3900
   ClientLeft      =   4395
   ClientTop       =   1830
   ClientWidth     =   5040
   LinkTopic       =   "Form1"
   ScaleHeight     =   3900
   ScaleWidth      =   5040
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   720
      Top             =   3360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton Command2 
      Caption         =   "STOP"
      Height          =   615
      Left            =   2813
      TabIndex        =   2
      Top             =   2640
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      Caption         =   "START"
      Height          =   615
      Left            =   653
      TabIndex        =   1
      Top             =   2640
      Width           =   1575
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   120
      Top             =   3360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "KEITHLEY"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   24
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   615
      Left            =   1193
      TabIndex        =   3
      Top             =   120
      Width           =   2655
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Caption         =   "Errors/Messages ???"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   1073
      TabIndex        =   0
      Top             =   1320
      Width           =   2895
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'
'This program outputs a square wave at a frequency of 250kHZ when the clock is set for
'a frequency of 500kHz using the "AO Recycle Mode" or "wave generation"
'
'For Waveform generation you must use the following settings:
'
' Req_mode = Interrupt or Dma
' Stop event = Command
' Sel_buf_notify = DL_Noevents or False
' data = 2 to 2048 samples per channel
' #buffers = 1
'
' use line below to get data
' convert = .VBArrayBufferConvert(0, 0, data, arrayWave, DL_tSINGLE, 0, 0)
'
'
Dim arrayWave() As Single
Dim convert, data As Single
Dim i As Single

Private Sub Command1_Click()
'connect + to TB41 and - to TB42
data = 2000   'number of data points to plot
ReDim arrayWave(data)

With SR
.Req_device = 0
.Req_DLL_name = "kpci3100"
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Refresh
End With
showmessage SR, "Driver Loaded"

LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh  ' get up to data info about our driver/device number (board)
' now test for paced mode feature
If (LDD.AO_DMA0 = DL_NoDMA) Then

    MsgBox "Your board does not have a paced Analog output feature.", vbCritical, _
        "Is this a KPCI-3116 or KPCI-3110?"
        
Else
    ' load an array with voltage data
    For i = 0 To ((data / 2) - 1)
    arrayWave(2 * i) = 0 ' loads even array VOLTAGE values
    arrayWave((2 * i + 1)) = 5 ' loads odd array VOLTAGE values
    Next i

With SR
.Req_subsystem = DL_AO
.Req_mode = DL_DMA
.Req_op = DL_START
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
' set the DAC update rate....500KHz max for KPCI-3110
'                            200KHz max for KPCI-3116
If LDD.Dev_Model = "KPCI-3110" Then
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 500000)
Else
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 200000)
End If
Form1.Caption = " AO Recycle Mode with " & LDD.Dev_Model
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 1
.Sel_chan_start = 0
.Sel_chan_startGainCode = .DLGain2Code(-1)
.Sel_buf_N = 1
.Sel_buf_samples = data  ' DAC FIFO is 4096 points max size
.Sel_buf_notify = DL_NOEVENTS
' move the voltage data to a memory buffer of DAC counts
convert = .VBArrayBufferConvert(0, 0, data, arrayWave, DL_tSINGLE, 0, 0)
.Refresh
End With
showmessage SR, "Data being sent"
End If
End Sub

Private Sub Command2_Click()
SR.Req_op = DL_STOP
SR.Refresh  ' stop the task
SR.Req_DLL_name = "" 'unloads driver
showmessage SR, "Output STOPPED"
End Sub

Sub showmessage(SR As Control, status As String)
If SR.Res_result <> 0 Then
Label1.Caption = SR.Message     'displays DriverLINX error
Else
Label1.Caption = status     'displays custom message
End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
SR.Req_DLL_name = "" 'unloads driver
End Sub

Private Sub SR_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
showmessage SR, "Data Lost"
End Sub

